<?php
/**
 * Plugin Name: Text to HTML Converter
 * Description: A simple plugin with a WYSIWYG editor for converting text to HTML, saving output, and exporting to a file.
 * Version: 1.2
 * Author: Anna Nicole Kucerova --  See also: <a href="https://nicoledigital.cz" target="_blank">NicoleDigital Network</a> - Zlepšete výkon vašeho webu See also: <a href="https://www.nicoledigital.cz/novyprojekt/" target="_blank">Eshop strugle help</a>
 */

add_action('admin_menu', 'tthc_add_admin_menu');

/**
 * Adds the plugin page to the WordPress admin menu.
 */
function tthc_add_admin_menu() {
    add_menu_page(
        'Text to HTML',
        'Text to HTML',
        'manage_options',
        'text_to_html_converter',
        'tthc_admin_page',
        'dashicons-media-code',
        80
    );
}

/**
 * Displays the admin page with WYSIWYG editor, styling settings, and download link.
 */
function tthc_admin_page() {
    $saved_output = get_option('tthc_saved_html', '');

    // Handle form submission
    if (isset($_POST['tthc_submit'])) {
        $html = wp_kses_post($_POST['tthc_input']);
        update_option('tthc_saved_html', $html);

        // Save HTML file
        $filename = 'converted_text_' . time() . '.html';
        $filepath = plugin_dir_path(__FILE__) . $filename;
        file_put_contents($filepath, $html);
        $download_link = plugins_url($filename, __FILE__);
    }

    // Get visual settings
    $bg_color = isset($_POST['tthc_bg_color']) ? sanitize_hex_color($_POST['tthc_bg_color']) : '#ffffff';
    $text_size = isset($_POST['tthc_text_size']) ? intval($_POST['tthc_text_size']) : 14;

    echo '<div class="wrap">';
    echo '<h1>Text to HTML Converter</h1>';

    echo '<form method="post">';
    
    echo '<h3>Editor</h3>';
    wp_editor($saved_output, 'tthc_editor', [
        'textarea_name' => 'tthc_input',
        'media_buttons' => false,
        'textarea_rows' => 10,
        'editor_css' => "body { background-color: {$bg_color}; font-size: {$text_size}px; }"
    ]);

    echo '<h3>Editor Appearance</h3>';
    echo '<p><label>Background Color: <input type="color" name="tthc_bg_color" value="' . esc_attr($bg_color) . '"></label></p>';
    echo '<p><label>Text Size: <input type="number" name="tthc_text_size" value="' . esc_attr($text_size) . '" min="10" max="30"> px</label></p>';

    echo '<p><input type="submit" name="tthc_submit" class="button button-primary" value="Save & Export HTML"></p>';
    echo '</form>';

    // Output HTML if submitted
    if (isset($html)) {
        echo '<h2>HTML Output</h2>';
        echo '<textarea rows="10" style="width:100%;">' . esc_textarea($html) . '</textarea>';
        echo '<p><a href="' . esc_url($download_link) . '" class="button button-secondary" download>Download HTML File</a></p>';
    }

    echo '</div>';
}

/**
 * Shortcode function to display the WYSIWYG editor on any page/post.
 * Usage: [text_to_html_editor]
 */
function tthc_render_shortcode_editor() {
    ob_start();

    $submitted = false;
    $html_output = '';

    // Check if submitted from frontend
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tthc_front_submit'])) {
        $html_output = wp_kses_post($_POST['tthc_front_input']);
        $submitted = true;
    }

    ?>
    <form method="post">
        <?php
        wp_editor('', 'tthc_front_input', [
            'textarea_name' => 'tthc_front_input',
            'media_buttons' => false,
            'textarea_rows' => 10
        ]);
        ?>
        <p><input type="submit" name="tthc_front_submit" class="button" value="Convert to HTML"></p>
    </form>

    <?php if ($submitted): ?>
        <h3>HTML Output</h3>
        <textarea rows="10" style="width:100%;"><?php echo esc_textarea($html_output); ?></textarea>
    <?php endif; ?>

    <?php
    return ob_get_clean();
}
add_shortcode('text_to_html_editor', 'tthc_render_shortcode_editor');
